// portability types

typedef UInt32 size_t;
typedef void FILE;

typedef double Number;
typedef struct {
  void *api;
} lua_State;
typedef int (*lua_CFunction)(lua_State *L);

// pre-defined references

#define LUA_NOREF       (-2)
#define LUA_REFNIL      (-1)
#define LUA_REFREGISTRY 0

// pre-defined tags

#define LUA_ANYTAG      (-1)
#define LUA_NOTAG       (-2)

// option for multiple returns in lua_call

#define LUA_MULTRET     (-1)

// minimum stack available for a C function

#define LUA_MINSTACK    20 
 
// error codes for lua_do*

#define LUA_ERRRUN      1
#define LUA_ERRFILE     2
#define LUA_ERRSYNTAX   3
#define LUA_ERRMEM      4
#define LUA_ERRERR      5

// types returned by `lua_type'

#define LUA_TNONE       (-1)
#define LUA_TUSERDATA   0
#define LUA_TNIL        1
#define LUA_TNUMBER     2   
#define LUA_TSTRING     3   
#define LUA_TTABLE      4   
#define LUA_TFUNCTION   5

// this macro may be the first definition inside each function.
#define PLUA_HEADER PluaAPI *api=L->api

// if the previous macro is used, the following macros may be used to
// to make transparent use of the Plua API.

#define plua_setlibdata(n,d) (api->plua_setlibdata(n,d))
#define plua_getlibdata(n) (api->plua_getlibdata(n))
#define plua_pusherror(L,e) (api->plua_pusherror(L,e))
#define lua_gettop(L) (api->lua_gettop(L))
#define lua_settop(L,i) (api->lua_settop(L,i))
#define lua_pushvalue(L,i) (api->lua_pushvalue(L,i))
#define lua_remove(L,i) (api->lua_remove(L,i))
#define lua_insert(L,i) (api->lua_insert(L,i))
#define lua_stackspace(L) (api->lua_stackspace(L))
#define lua_type(L,i) (api->lua_type(L,i))
#define lua_typename(L,t) (api->lua_typename(L,t))
#define lua_isnumber(L,i) (api->lua_isnumber(L,i))
#define lua_isstring(L,i) (api->lua_isstring(L,i))
#define lua_iscfunction(L,i) (api->lua_iscfunction(L,i))
#define lua_tag(L,i) (api->lua_tag(L,i))
#define lua_equal(L,i1,i2) (api->lua_equal(L,i1,i2))
#define lua_lessthan(L,i1,i2) (api->lua_lessthan(L,i1,i2))
#define lua_tonumber(L,i) (api->lua_tonumber(L,i))
#define lua_tostring(L,i) (api->lua_tostring(L,i))
#define lua_strlen(L,i) (api->lua_strlen(L,i))
#define lua_tocfunction(L,i) (api->lua_tocfunction(L,i))
#define lua_touserdata(L,i) (api->lua_touserdata(L,i))
#define lua_topointer(L,i) (api->lua_topointer(L,i))
#define lua_pushnil(L) (api->lua_pushnil(L))
#define lua_pushnumber(L,n) (api->lua_pushnumber(L,n))
#define lua_pushlstring(L,s,l) (api->lua_pushlstring(L,s,l))
#define lua_pushstring(L,s) (api->lua_pushstring(L,s))
#define lua_pushcclosure(L,f,n) (api->lua_pushcclosure(L,f,n))
#define lua_pushusertag(L,u,t) (api->lua_pushusertag(L,u,t))
#define lua_getglobal(L,n) (api->lua_getglobal(L,n))
#define lua_gettable(L,i) (api->lua_gettable(L,i))
#define lua_rawget(L,i) (api->lua_rawget(L,i))
#define lua_rawgeti(L,i,n) (api->lua_rawgeti(L,i,n))
#define lua_getglobals(L) (api->lua_getglobals(L))
#define lua_gettagmethod(L,t,e) (api->lua_gettagmethod(L,t,e))
#define lua_getref(L,r) (api->lua_getref(L,r))
#define lua_newtable(L) (api->lua_newtable(L))
#define lua_setglobal(L,n) (api->lua_setglobal(L,n))
#define lua_settable(L,i) (api->lua_settable(L,i))
#define lua_rawset(L,i) (api->lua_rawset(L,i))
#define lua_rawseti(L,i,n) (api->lua_rawseti(L,i,n))
#define lua_setglobals(L) (api->lua_setglobals(L))
#define lua_settagmethod(L,t,e) (api->lua_settagmethod(L,t,e))
#define lua_ref(L,l) (api->lua_ref(L,l))
#define lua_call(L,a,r) (api->lua_call(L,a,r))
#define lua_rawcall(L,a,r) (api->lua_rawcall(L,a,r))
#define lua_dofile(L,f) (api->lua_dofile(L,f))
#define lua_dostring(L,s) (api->lua_dostring(L,s))
#define lua_dobuffer(L,b,s,n) (api->lua_dobuffer(L,b,s,n))
#define lua_newtag(L) (api->lua_newtag(L))
#define lua_copytagmethods(L,t,f) (api->lua_copytagmethods(L,t,f))
#define lua_settag(L,t) (api->lua_settag(L,t))
#define lua_error(L,s) (api->lua_error(L,s))
#define lua_errorx(L,s,e) (api->lua_errorx(L,s,e))
#define lua_unref(L,r) (api->lua_unref(L,r))
#define lua_next(L,i) (api->lua_next(L,i))
#define lua_getn(L,i) (api->lua_getn(L,i))
#define lua_concat(L,n) (api->lua_concat(L,n))
#define lua_newuserdata(L,s) (api->lua_newuserdata(L,s))
#define luaL_argerror(L,n,e) (api->luaL_argerror(L,n,e))
#define luaL_check_lstr(L,n,l) (api->luaL_check_lstr(L,n,l))
#define luaL_opt_lstr(L,n,d,l) (api->luaL_opt_lstr(L,n,d,l))
#define luaL_check_number(L,n) (api->luaL_check_number(L,n))
#define luaL_opt_number(L,n,d) (api->luaL_opt_number(L,n,d))
#define luaL_checkstack(L,m) (api->luaL_checkstack(L,m))
#define luaL_checktype(L,n,t) (api->luaL_checktype(L,n,t))
#define luaL_checkany(L,n) (api->luaL_checkany(L,n))

#define fopen(n,m) (api->fopen(n,m))
#define fclose(f) (api->fclose(f))
#define feof(f) (api->feof(f))
#define fseek(f,o,m) (api->fseek(f,o,m))
#define ftell(f) (api->ftell(f))
#define fread(b,s,n,f) (api->fread(b,s,n,f))
#define fwrite(b,s,n,f) (api->fwrite(b,s,n,f))
#define fputs(s,f) (api->fputs(s,f))
#define fgets(s,l,f) (api->fgets(s,l,f))


// some useful macros

#define lua_pop(L,n)            lua_settop(L, -(n)-1)

#define lua_register(L,n,f)     (lua_pushcfunction(L, f), lua_setglobal(L, n))
#define lua_pushuserdata(L,u)   lua_pushusertag(L, u, 0)
#define lua_pushcfunction(L,f)  lua_pushcclosure(L, f, 0)
#define lua_clonetag(L,t)       lua_copytagmethods(L, lua_newtag(L), (t))

#define lua_isfunction(L,n)     (lua_type(L,n) == LUA_TFUNCTION)
#define lua_istable(L,n)        (lua_type(L,n) == LUA_TTABLE)
#define lua_isuserdata(L,n)     (lua_type(L,n) == LUA_TUSERDATA)
#define lua_isnil(L,n)          (lua_type(L,n) == LUA_TNIL)
#define lua_isnull(L,n)         (lua_type(L,n) == LUA_TNONE)

#define lua_getregistry(L)      lua_getref(L, LUA_REFREGISTRY)

#define luaL_arg_check(L, cond,numarg,extramsg) if (!(cond)) luaL_argerror(L, numarg,extramsg)
#define luaL_check_string(L,n)  (luaL_check_lstr(L, (n), NULL))
#define luaL_opt_string(L,n,d)  (luaL_opt_lstr(L, (n), (d), NULL))
#define luaL_check_int(L,n)     ((int)luaL_check_number(L, n))
#define luaL_check_long(L,n)    ((long)luaL_check_number(L, n))
#define luaL_opt_int(L,n,d)     ((int)luaL_opt_number(L, n,d))
#define luaL_opt_long(L,n,d)    ((long)luaL_opt_number(L, n,d))

